from gi.repository import Gst
from .src_branch import LinearSrcBranch


class SilentVideo(LinearSrcBranch):

    def __init__(self, bus, session_id, width, height, fps, pattern):

        super(SilentVideo, self).__init__(bus, session_id)

        src = self.make("gltestsrc")
        src.set_property("do-timestamp", True)
        src.set_property("is-live", True)
        src.set_property("pattern", pattern)

        src_caps_filter = self.make("capsfilter")
        src_caps = Gst.Caps.from_string("video/x-raw(memory:GLMemory),format=RGBA,width=%d,height=%d,framerate=%d/1" % (width, height, fps))
        src_caps_filter.set_property("caps", src_caps)

        queue = self.make_default_queue("silent_video")

        self.elements = [src, src_caps_filter, queue]
        self.link_many(*self.elements)
        self.add_static_ghost_pad()

