from gi.repository import Gst
from .branch import Branch
from classes import logger as log


class SrcBranch(Branch):

    def __init__(self, bus, session_id):
        super(SrcBranch, self).__init__(bus, session_id)

    def get_first_src_pad(self):
        ''' overwrite me '''
        log.error("get_first_src_pad should be overwritten")
        return

    def get_first_sink_pad(self):
        ''' overwrite me '''
        log.error("get_first_sink_pad should be overwritten")
        return

    def get_last_sink_pad(self):
        ''' overwrite me '''
        log.error("get_last_sink_pad should be overwritten")
        return


class LinearSrcBranch(SrcBranch):

    def __init__(self, *args, **kwargs):
        super(LinearSrcBranch, self).__init__(*args, **kwargs)
        self.elements = []

    def get_first_sink_pad(self):
        return self.elements[1].get_static_pad('sink')

    def get_first_src_pad(self):
        return self.elements[0].get_static_pad('src')

    def get_last_sink_pad(self):
        self.elements[-1].get_static_pad("sink")

    def add_static_ghost_pad(self):
        src_pad = self.elements[-1].get_static_pad('src')
        ghost_src_pad = Gst.GhostPad.new('src', src_pad)
        self.bin.add_pad(ghost_src_pad)

