from .filter_branch import FilterBranch
from classes import logger as log


class WidgetFilter(FilterBranch):

    def __init__(self, bus, session_id, filter):
        super(WidgetFilter, self).__init__(bus, session_id)
        self.element = None
        self.filter = filter
        self.filter_id = filter['stream_widget_filter_id']
        self.element_name = filter['filter_type']
        self.props = filter['property_values']

        self.element = self.make(self.element_name, **self.props)
        log.info('widget filter name: %s type: %s, props: %s', self.element.name, self.element_name, self.props)

        # (speex noise suppression has buffer size of 20ms, so something more
        # than 20ms should be fine)
        audio_queue = self.make_queue("{}_queue".format(self.element_name),
                                      max_size_time=40000000)  # 40ms queue

        self.elements = [self.element, audio_queue]
        self.link_many(*self.elements)
        self.add_static_ghost_pads()

    def can_update(self, new_filter):
        return True

    def update(self, new_filter):
        # if the property values changed, then we wanna update the elemnt
        # property
        if self.filter['property_values'] != new_filter['property_values']:
            old_props = self.filter['property_values']
            new_props_items = new_filter['property_values'].items()
            for k, v in new_props_items:
                # old value and new value = same, noop
                if old_props[k] == v:
                    continue
                log.debug('updating element name: %s key: %s value: %s', self.element.name, k, v)
                self.element.set_property(k, v)
        self.filter = new_filter

