class GstreamerError(Exception):
    pass

class LinkError(GstreamerError):
    pass

class CreateError(GstreamerError):
    pass

class StateChangeError(GstreamerError):
    pass

class NoBranchError(GstreamerError):
    pass

class PublisherError(Exception):
    def __init__(self, widget_id, *args):
        self.widget_id = widget_id
        super(PublisherError, self).__init__(self, *args)

class PublisherDeviceNotFoundError(PublisherError):
    pass

class PublisherFileNotFoundError(PublisherError):
    pass

