import logging
import sys
import os
import datetime
from config import options as config

class NewLineFormatter(logging.Formatter):

    def __init__(self, *args, **kwargs):
        super(NewLineFormatter, self).__init__(*args, **kwargs)

    def formatException(self, exc_info):
        exception_string = super(NewLineFormatter, self).formatException(exc_info)
        return exception_string

    def format(self, record):
        result = super(NewLineFormatter, self).format(record)
        return result

    def formatTime(self, record, datefmt=None):
        return datetime.datetime.utcnow().isoformat(timespec='milliseconds')  + "Z"


logger = logging.getLogger()
logger.setLevel(getattr(logging, config.DEBUG_LEVEL))
streamHandler = logging.StreamHandler(sys.stdout)
streamHandler.terminator = '\n'
streamHandler.setLevel(getattr(logging, config.DEBUG_LEVEL))
formatter = NewLineFormatter('%(asctime)s\tmercy\t%(levelname)s\t%(pathname)s:%(lineno)s - %(message)s\r')

streamHandler.setFormatter(formatter)
logger.addHandler(streamHandler)

debug = logger.debug
info = logger.info
warning = logger.warning
error = logger.error
critical = logger.critical
exception = logger.exception
