from classes.publishers.visual import VisualPublisher
from classes.registry import Registry
from classes import logger as log


class CaptureSettingsPublisher(VisualPublisher):

    def __init__(self, publisher_payload, session):
        self.cap_settings = {}
        self.base_cap_settings = {}
        self.crop_branch = None
        super(CaptureSettingsPublisher, self).__init__(publisher_payload, session)

    def get_registry_key(self):
        raise Exception("This function should be overriden")

    def set_values(self, publisher_payload):
        super(CaptureSettingsPublisher, self).set_values(publisher_payload)
        registry = Registry()
        registry_key = self.get_registry_key()
        for (key, value) in self.cap_settings.items():
            old_value = self.old_cap_settings.get(key, None)
            log.debug("CaptureSettingsPublisher set_value: %s %s %s" % (key, old_value, value))
            if value != old_value:
                registry.set_value(registry_key, key, value)
        for (key, value) in self.base_cap_settings.items():
            old_value = self.old_base_cap_settings.get(key, None)
            if value != old_value:
                log.debug("BaseCaptureSettingsPublisher set_value: %s %s %s" % (key, old_value, value))
                registry.set_value(registry_key, key, value)

    def get_values(self, publisher_payload):
        values = super(CaptureSettingsPublisher, self).get_values(publisher_payload)
        values['base_cap_settings'] = {"CaptureHeight": self.session.height,
                                       "CaptureWidth": self.session.width,
                                       "CaptureFPS": self.session.fps}
        old_cap_settings = self.cap_settings
        values['old_cap_settings'] = old_cap_settings
        values['cap_settings'] = publisher_payload["cap_settings"]
        values['old_base_cap_settings'] = self.base_cap_settings
        return values

    def can_update(self, publisher_payload, **kwargs):
        super_can_update = super(CaptureSettingsPublisher, self).can_update(publisher_payload, **kwargs)
        return super_can_update
