from classes.publishers.visual import VisualPublisher
from classes import logger as log
from classes import device_factory
from classes.branches.directshow_video import DirectShowVideo
from classes.error import PublisherDeviceNotFoundError


class CaptureCardPublisher(VisualPublisher):
    def __init__(self, publisher_payload, session):
        super(CaptureCardPublisher, self).__init__(publisher_payload, session)

    def get_values(self, publisher_payload):
        values = super(CaptureCardPublisher, self).get_values(publisher_payload)
        values["fps"] = publisher_payload["fps"]
        return values

    def make_src_branches(self):
        device = device_factory.get_video_device(self.device_id)
        if not device:
            raise PublisherDeviceNotFoundError(self.publisher_payload['widget_id'], "Failed to find capturecard device. device_id: {}".format(self.device_id))

        request_preferred_format = { 'width': self.load_width, 'height': self.load_height, 'framerate': self.fps }
        preferred_caps = device_factory.get_preferred_caps(device, request_preferred_format)
        preferred_output_type = preferred_caps.get('type')
        preferred_format = preferred_caps.get('pixel_format')
        preferred_fps = int(preferred_caps.get('framerate'))
        src = DirectShowVideo(self.session.bus, self.session.session_id, device.display_name, device.device_path, preferred_output_type, preferred_caps.get('width'), preferred_caps.get('height'), preferred_fps, preferred_format, self.cloned_id)
        self.src = src
        return [self.src]

