from .publisher import Publisher
from classes import logger as log
from classes.publishers.audio_device import AudioDevice
from classes.branches.wasapi import Wasapi
from classes.branches.audio_volume import AudioVolume


class DesktopAudio(AudioDevice):

    def __init__(self, publisher_payload, session):
        super(DesktopAudio, self).__init__(publisher_payload, session)
        self.audio_src = None

    def make_src_branches(self):
        display_name = "Desktop Audio"
        self.audio_src = Wasapi(self.session.bus, self.session.session_id,
                                "loopback", False, self.session.restart_session)
        return [self.audio_src]

    def need_update(self):
        return self.audio_src and self.audio_src.need_update()

