from classes.publishers.visual import VisualPublisher
from classes import logger as log
from classes.branches.gamecapture import GameCapture
from config import options as config
import os
import sys

PYTHON_DIR = os.path.split(sys.executable)[0]
BASE_DIR = os.path.split(PYTHON_DIR)[0]

BEBO_DLLS_DIR_DEFAULT = os.path.join(BASE_DIR, 'bebodlls')

if config.is_local():
    BEBO_DLLS_DIR = os.getenv("BEBO_DLLS", BEBO_DLLS_DIR_DEFAULT)
else:
    BEBO_DLLS_DIR = BEBO_DLLS_DIR_DEFAULT

log.info('BEBO_DLLS_DIR: %s', BEBO_DLLS_DIR)

class GameCapturePublisher(VisualPublisher):

    def __init__(self, publisher_payload, session):
        super(GameCapturePublisher, self).__init__(publisher_payload, session)
        self.window_name = publisher_payload["cap_settings"]["windowName"]
        self.window_class_name = publisher_payload["cap_settings"]["windowClassName"]
        self.anti_cheat = publisher_payload["cap_settings"]["antiCheat"]
        self.dll_path = BEBO_DLLS_DIR

    def make_src_branches(self):
        src = GameCapture(self.session.bus, self.session.session_id, self.session.width, self.session.height, self.session.fps, self.window_name, self.window_class_name, self.anti_cheat, self.dll_path)
        return [src]

    def get_values(self, publisher_payload):
        values = super(GameCapturePublisher, self).get_values(publisher_payload)
        values['window_name'] = publisher_payload["cap_settings"]["windowName"]
        values['window_class_name'] = publisher_payload["cap_settings"]["windowClassName"]
        values['anti_cheat'] = publisher_payload["cap_settings"]["antiCheat"]
        values['fps'] = self.session.fps
        return values

    def can_update(self, publisher_payload, **kwargs):
        super_can_update = super(GameCapturePublisher, self).can_update(publisher_payload, **kwargs)
        cap_settings = publisher_payload['cap_settings']
        if cap_settings.get('windowName', None) != self.window_name:
            return False
        if cap_settings.get('windowClassName', None) != self.window_class_name:
            return False
        if cap_settings.get('antiCheat', None) != self.anti_cheat:
            return False
        return super_can_update

