from classes.publishers.visual import VisualPublisher
from classes import logger as log
from classes.branches.video_src import VideoSrc
from classes.util import make_bebofs_path
from classes.error import PublisherFileNotFoundError
from pathlib import Path


class MediaVideoPublisher(VisualPublisher):
    def __init__(self, publisher_payload, session):
        super(MediaVideoPublisher, self).__init__(publisher_payload, session)
        self.src = None

    def get_values(self, publisher_payload):
        values = super(MediaVideoPublisher, self).get_values(publisher_payload)
        values['filename'] = '{}\\{}'.format(make_bebofs_path(), values['data'].get('file_path', None))
        values['file_path'] = values['data'].get('file_path', None)
        values['volume'] = publisher_payload.get('volume', None)
        return values

    def get_running_sink_branch(self):
        return self.session.video_mixer

    def get_running_sink_pad(self):
        return self.session.video_mixer.get_sink_pad(self.publisher_id)

    def link_to_running_sink(self, branch):
        log.debug("linking %s to %s" % (branch.name, self.session.video_mixer.name))
        self.session.video_mixer.add_input_branch(branch, self.publisher_id, self.pixel_position, self.z_order, self.alpha)

    def update_running(self):
        super(MediaVideoPublisher, self).update_running()
        self.set_src_mute()
        self.set_src_volume()

    def make_src_branches(self):
        if not Path(self.filename).exists():
            self.session.download_file(self.widget_id, self.file_path)
            raise PublisherFileNotFoundError(self.publisher_payload['widget_id'], "Failed to find file locally. filename: {}".format(self.filename))

        self.src = VideoSrc(self.session.bus, self.session.session_id, self.filename, loop=True, audio_output_type="loopback", width=self.session.width, height=self.session.height)
        self.set_src_mute()
        self.set_src_volume()
        return [self.src]

    def set_src_mute(self):
        is_muted = not self.visible
        self.src.set_loopback_mute(is_muted)

    def set_src_volume(self):
        if self.volume is not None:
            self.src.set_loopback_volume(self.volume)

    def has_element(self, element):

        if super(MediaVideoPublisher, self).has_element(element):
            return True

        bins = [self.src.interpipeline]
        for b in bins:
            if b == element:
                return True
            for e in b.iterate_elements():
                if e == element:
                    return True
        return False

