from classes.publishers.capture_settings import CaptureSettingsPublisher
from classes import logger as log
from classes.branches.directshow_video import DirectShowVideo

MAX_FPS = 30


class ScreenCapturePublisher(CaptureSettingsPublisher):
    def __init__(self, publisher_payload, session):
        super(ScreenCapturePublisher, self).__init__(publisher_payload, session)

    def make_src_branches(self):
        src = DirectShowVideo(self.session.bus, self.session.session_id, "bebo-screen-capture", None, "video/x-raw", self.session.width, self.session.height, self.session.fps, "I420", cloned_id="screen")
        return [src]

    def get_values(self, publisher_payload):
        values = super(ScreenCapturePublisher, self).get_values(publisher_payload)
        values["fps"] = min(self.session.fps, MAX_FPS)
        return values

    def can_update(self, publisher_payload, **kwargs):
        super_can_update = super(ScreenCapturePublisher, self).can_update(publisher_payload, **kwargs)
        if publisher_payload["cap_settings"]["id"] != self.publisher_payload["cap_settings"]["id"]:
            return False
        return super_can_update

    def get_registry_key(self):
        return "DesktopCapture"

    def can_pause(self):
        return False

