from classes.publishers.visual import VisualPublisher
from classes.branches.silent_video import SilentVideo


class SilentVideoPublisher(VisualPublisher):
    def __init__(self, publisher_payload, session):
        super(SilentVideoPublisher, self).__init__(publisher_payload, session)
        self.pattern = publisher_payload.get('pattern', "black")
        self.z_order = publisher_payload.get('z_order', 0)

    def make_src_branches(self):
        src = SilentVideo(self.session.bus, self.session.session_id, self.load_width, self.load_height, 1, self.pattern)
        return [src]

    def make_running_branches(self):
        return []

    def can_update(self, publisher_payload, **kwargs):
        super_can_update = super(VisualPublisher, self).can_update(publisher_payload, **kwargs)
        return super_can_update

    def update_running(self):
        super(SilentVideoPublisher, self).update_running()

    def can_pause(self):
        return False

