import math

from .publisher import Publisher
from classes import logger as log


class TransitionPublisher(Publisher):

    def __init__(self, publisher_payload, session):
        super(TransitionPublisher, self).__init__(publisher_payload, session)

    def get_values(self, publisher_payload):
        values = super(TransitionPublisher, self).get_values(publisher_payload)
        # FIXME - remove business logic from getter
        values['pixel_position'] = {
                'width': self.session.width,
                'height': self.session.height,
                'x': 0,
                'y': 0}

        values['z_order'] = publisher_payload['z_order']
        values['alpha'] = 1.0
        values['content_type'] = publisher_payload['content_type']
        return values

    def get_running_sink_branch(self):
        return self.session.video_mixer

    def get_running_sink_pad(self):
        return self.session.video_mixer.get_sink_pad(self.publisher_id)

    def link_to_running_sink(self, branch):
        log.debug("linking %s to %s" % (branch, self.session.video_mixer))
        self.session.video_mixer.add_input_branch(branch, self.publisher_id, self.pixel_position, self.z_order, self.alpha)

