from classes.publishers.transition import TransitionPublisher
from classes import logger as log
from classes.branches.video_src import VideoSrc
import hashlib
import os
from config import options as config
from gi.repository import Gst

HOME_DIR = os.getenv("LOCALAPPDATA")
VIDEOS_DIR = "%s\\%s\\User Data\\Videos" % (HOME_DIR, config.APP_NAME)


class VideoTransitionPublisher(TransitionPublisher):

    def __init__(self, publisher_payload, session):
        super(VideoTransitionPublisher, self).__init__(publisher_payload, session)
        self.on_finished = None
        self.gap_cnt = 0

    def get_values(self, publisher_payload):
        values = super(VideoTransitionPublisher, self).get_values(publisher_payload)
        media_url = publisher_payload['media_url'].encode('utf-8')
        values['filename'] = '{}\\{}.webm'.format(VIDEOS_DIR, hashlib.sha1(media_url).hexdigest())
        return values

    def make_running_branches(self):
        return []

    def make_src_branches(self):
        self.src = VideoSrc(self.session.bus, self.session.session_id, self.filename, on_finished=self.on_finished_cb, include_alpha=True)
        return [self.src]

    def pause(self):
        super(VideoTransitionPublisher, self).pause()
        self.src.seek_to_start()
        self.gap_cnt = 0

    def on_finished_cb(self):
        pass

    def on_end_of_video_eos_cb(self, pad, info, user_data):

        event = info.get_event()
        if not event or event.type != Gst.EventType.CUSTOM_DOWNSTREAM:
            return Gst.PadProbeReturn.OK

        if self.on_finished:
            # TODO - better to run on worker thread?
            self.on_finished()
        if self._end_of_video_probe_id:
            pad.remove_probe(self._end_of_video_probe_id)
            self._end_of_video_probe_id = None
        return Gst.PadProbeReturn.DROP

    def on_end_of_video_block_eos(self):
        ultimate_sink_pad = self.get_running_sink_pad()
        self._end_of_video_probe_id = ultimate_sink_pad.add_probe(
            Gst.PadProbeType.EVENT_DOWNSTREAM | Gst.PadProbeType.BLOCK,
            self.on_end_of_video_eos_cb, None)
        structure = Gst.Structure.new_empty("end_video")
        event = Gst.Event.new_custom(Gst.EventType.CUSTOM_DOWNSTREAM, structure)
        self.src.get_first_sink_pad().send_event(event)

    def on_end_of_video_listener(self, pad, info, user_data):
        buffer = info.get_buffer()
        if buffer.has_flags(Gst.BufferFlags.GAP):
            self.gap_cnt += 1
            log.debug("end of video file listener consecutve gap %d", self.gap_cnt)
            if self.gap_cnt > 5:
                self.on_end_of_video_block_eos()
                if self.end_of_video_probe_id:
                    pad.remove_probe(self.end_of_video_probe_id)
                    self.end_of_video_probe_id = None
        else:
            self.gap_cnt = 0
        # TODO OK or PASS?
        return Gst.PadProbeReturn.OK

    def add_listener(self, cb=None):
        self.video_sink_pad = self.src.get_first_sink_pad()
        self.end_of_video_probe_id = self.video_sink_pad.add_probe(
            Gst.PadProbeType.BUFFER,
            self.on_end_of_video_listener,
            None)

