import re

from classes.publishers.visual import VisualPublisher
from classes import logger as log
from classes import device_factory
from classes.branches.directshow_video import DirectShowVideo
from classes.error import PublisherDeviceNotFoundError


class WebcamPublisher(VisualPublisher):

    def __init__(self, publisher_payload, session):
        self.name = None
        self.device_id = None
        self.load_width = None
        self.load_height = None
        self.fps = None
        self.cloned_id = None
        super(WebcamPublisher, self).__init__(publisher_payload, session)

    def get_values(self, publisher_payload):
        values = super(WebcamPublisher, self).get_values(publisher_payload)
        values["fps"] = publisher_payload["fps"]
        return values

    def make_src_branches(self):
        if not self.name:
            log.error("no device name. name=%s, payload = %s" % (self.name, self.publisher_payload))

        device = device_factory.get_video_device(self.device_id)
        if not device or not device.caps:
            raise PublisherDeviceNotFoundError(self.publisher_payload['widget_id'], "Failed to find webcam device. device_id: {}".format(self.device_id))

        request_preferred_format = { 'width': self.load_width, 'height': self.load_height, 'framerate': self.fps }
        preferred_caps = device_factory.get_preferred_caps(device, request_preferred_format)
        preferred_output_type = preferred_caps.get('type')
        preferred_format = preferred_caps.get('pixel_format')
        preferred_fps = int(preferred_caps.get('framerate'))
        src = DirectShowVideo(self.session.bus, self.session.session_id, device.display_name, device.device_path, preferred_output_type, preferred_caps.get('width'), preferred_caps.get('height'), preferred_fps, preferred_format, self.cloned_id)
        self.src = src
        return [self.src]

    def can_update(self, publisher_payload, **kwargs):
        super_can_update = super(WebcamPublisher, self).can_update(publisher_payload, **kwargs)

        must_be_equal = ["device_id", "resolution", "fps"]

        for prop in must_be_equal:
            if self.publisher_payload[prop] != publisher_payload[prop]:
                log.debug("can't update %s : %s -> %s", prop,
                          self.publisher_payload[prop],
                          publisher_payload[prop])
                return False

        return super_can_update

