from classes.publishers.capture_settings import CaptureSettingsPublisher
from classes import logger as log
from classes.branches.directshow_video import DirectShowVideo

MAX_FPS = 30


class WindowCapturePublisher(CaptureSettingsPublisher):
    def __init__(self, publisher_payload, session):
        super(WindowCapturePublisher, self).__init__(publisher_payload, session)

    def make_src_branches(self):
        src = DirectShowVideo(self.session.bus, self.session.session_id, "bebo-window-capture", None, "video/x-raw", self.load_width, self.load_height, self.session.fps, None, cloned_id="window")
        return [src]

    def get_values(self, publisher_payload):
        values = super(WindowCapturePublisher, self).get_values(publisher_payload)
        values["fps"] = min(self.session.fps, MAX_FPS)
        return values

    def get_registry_key(self):
        return "WindowCapture"

    def can_update(self, publisher_payload, **kwargs):
        super_can_update = super(WindowCapturePublisher, self).can_update(publisher_payload, **kwargs)
        if publisher_payload["cap_settings"]["id"] != self.publisher_payload["cap_settings"]["id"]:
            return False
        if publisher_payload["cap_settings"]["windowClassName"] != self.publisher_payload["cap_settings"]["windowClassName"]:
            return False
        if publisher_payload["cap_settings"]["windowHandle"] != self.publisher_payload["cap_settings"]["windowHandle"]:
            return False
        if publisher_payload["cap_settings"]["windowName"] != self.publisher_payload["cap_settings"]["windowName"]:
            return False
        if publisher_payload["cap_settings"]["once"] != self.publisher_payload["cap_settings"]["once"]:
            return False
        return super_can_update

    def can_pause(self):
        return False

