from classes.util import SingletonDecorator
import winreg
import numbers

BEBO_PREFIX = "Software\\Bebo"


class BeboKey():

    def __init__(self, key, root_key=winreg.HKEY_CURRENT_USER):
        self.key = BEBO_PREFIX + "\\" + key
        self.root_key = root_key
        self.permission = winreg.KEY_ALL_ACCESS if root_key is winreg.HKEY_CURRENT_USER else winreg.KEY_READ

    def __enter__(self):
        try:
            self.reg_key = winreg.OpenKey(self.root_key, self.key, 0, self.permission)
        except:
            winreg.CreateKey(self.root_key, self.key)
            self.reg_key = winreg.OpenKey(self.root_key, self.key, 0, self.permission)

    def __exit__(self, exc_type, exc_val, exc_tb):
        winreg.CloseKey(self.reg_key)

    def read(self, name):
        return winreg.QueryValueEx(self.reg_key, name)[0]

    def write(self, name, value):
        reg_type = winreg.REG_SZ
        if isinstance(value, numbers.Number):
            reg_type = winreg.REG_DWORD
        elif isinstance(value, str):
            reg_type = winreg.REG_SZ
        else:
            raise TypeError("bad type -- not a string or number (%s, %s)" % (name, value))

        winreg.SetValueEx(self.reg_key, name, 0, reg_type, value)


class Registry:
    def __init__(self):
        pass

    def set_value(self, key, name, value):
        key = BeboKey(key)
        with key:
            key.write(name, value)

    def get_value(self, key, name, root_key=winreg.HKEY_CURRENT_USER):
        key = BeboKey(key, root_key)
        with key:
            return key.read(name)


Registry = SingletonDecorator(Registry)
