from classes.stats import qos
from classes.system.gpu import gpu


class GpuStats:
    def __init__(self, gpu):
        self.gpu = gpu

    def start(self):
        if self.gpu and self.gpu.device_count:
            qos.add_cb(self.get_stats)

    def get_stats(self):
        gpu_stat = {}
        device_stat = { 'gpu': gpu_stat }
        gpu_stat['driver_version_tx'] = self.gpu.driver_version
        gpu_stat['device_cnt'] = self.gpu.device_count
        utilization_stats = self.gpu.get_utilization()
        gpu_stat['gpu_dec'] = utilization_stats.gpu
        gpu_stat['mem_dec'] = utilization_stats.memory
        return device_stat


gpu_stats = GpuStats(gpu)

