import threading
import time
from classes import logger as log
from . import qos

INTERVAL = 15


class StatSender(threading.Thread):

    stopped = False

    def __init__(self, get_stats, send_stats):
        super(StatSender, self).__init__()
        log.info("starting StatSender")
        self.get_stats = get_stats
        self.send_stats = send_stats

    def run(self):
        while not self.stopped:
            try:
                stats = self.get_stats()
                if stats is not None and len(stats) > 0:
                    self.send_stats(stats)
            except Exception as e:
                log.exception("failed to get_stats loop %s", e)
            time.sleep(INTERVAL)

    def start(self):
        super(StatSender, self).start()
        qos.start()

    def stop(self):
        self.stopped = True
        qos.stop()
