import os
import argparse

parser = argparse.ArgumentParser(description='Mercy Arg Parser')
parser.add_argument('--port', type=int, default=3050, help='mercy port')
parser.add_argument('--env', type=str, default="local", help='environment')
args = parser.parse_args()


# FIXME - move RTMP_URL back out

class Config:
    def __init__(self, env):
        self.CODE_NAME = 'Mercy'
        self.PORT = os.getenv('WS_PORT', args.port)
        self.ENV = env
        self.APP_NAME = 'Bebo-Local'
        self.CRASH_DUMP_URL = "https://pharah-cf.bebo-dev.com/breakpad"
        self.RTMP_URL = os.getenv("BEBO_RTMP", "rtmp://walle.bebo-dev.com/live")
        self.DEBUG_LEVEL = os.getenv('MERCY_DEBUG_LEVEL')
        self.LOG_API_URL = "https://log.bebo-dev.com"
        self.WWW_URL = "https://bebo-dev.com"
        if self.DEBUG_LEVEL:
            self.DEBUG_LEVEL = self.DEBUG_LEVEL.strip().upper()
            if self.DEBUG_LEVEL not in ['DEBUG', 'INFO', 'WARNING', 'ERROR', 'CRITICAL', 'EXCEPTION']:
                self.DEBUG_LEVEL = 'DEBUG'
        self.DEBUG_LEVEL = self.DEBUG_LEVEL or 'DEBUG'

    def is_local(self):
        return self.ENV not in ['prod', 'ptr', 'dev']


class LocalConfig(Config):
    def __init__(self):
        super().__init__("local")


class DevConfig(Config):
    def __init__(self):
        super().__init__("dev")
        self.APP_NAME = 'Bebo-Dev'
        self.DEBUG_LEVEL = 'DEBUG'
        self.RTMP_URL = os.getenv("BEBO_RTMP", "rtmp://walle.bebo-dev.com/live")
        self.CRASH_DUMP_URL = "https://pharah-cf.bebo-dev.com/breakpad"
        self.LOG_API_URL = "https://log.bebo-dev.com"
        self.WWW_URL = "https://bebo-dev.com"


class PtrConfig(Config):
    def __init__(self):
        super().__init__("ptr")
        self.APP_NAME = 'Bebo-Ptr'
        self.DEBUG_LEVEL = 'INFO'
        self.RTMP_URL = "rtmp://walle.bebo-ptr.com/live"
        self.CRASH_DUMP_URL = "https://pharah-cf.bebo-ptr.com/breakpad"
        self.LOG_API_URL = "https://log.bebo-ptr.com"
        self.WWW_URL = "https://bebo-ptr.com"


class ProdConfig(Config):
    def __init__(self):
        super().__init__("prod")
        self.APP_NAME = 'Bebo'
        self.DEBUG_LEVEL = 'INFO'
        self.RTMP_URL = "rtmp://walle.bebo.com/live"
        self.CRASH_DUMP_URL = "https://pharah-cf.bebo.com/breakpad"
        self.LOG_API_URL = "https://log.bebo.com"
        self.WWW_URL = "https://bebo.com"


env = os.getenv("ENV", args.env)
if env == "prod":
    options = ProdConfig()
elif env == "ptr":
    options = PtrConfig()
elif env == "dev":
    options = DevConfig()
else:
    options = LocalConfig()
config = options


