import json
import time
from classes import logger as log

class LogRequest(object):

    def process_request(self, req, resp):
        try:
            split_path  = req.path.split("/")
            obj = split_path[1]

            req.start_time = time.time()

            if len(split_path) > 3:
                action = req.path.split("/")[3]
            elif len(split_path) > 2:
                action = req.path.split("/")[2]
            else:
                action = obj
            data = {
                "routing_key": "%s.%s.%s" % (req.method, obj, action),
                "method_tx": req.method,
                "ips": req.access_route,
                "query_string_tx": req.query_string,
                "params_map": req.params,
                "headers_map": req.headers
            }
            log.info("<<< request %s %s %s %s" % (data['routing_key'], req.query_string, req.params, req.context.get('doc', "")))
        except Exception as e:
            log.error("faiiled to log request %s", e, exc_info=True)
        pass

    def process_response(self, req, resp, resource):
        try:
            request_time = (time.time() - req.start_time) * 1000

            split_path  = req.path.split("/")
            obj = split_path[1]
            if len(split_path) > 3:
                action = req.path.split("/")[3]
            elif len(split_path) > 2:
                action = req.path.split("/")[2]
            else:
                action = obj
            data = {
                "routing_key": "%s.%s.%s" % (req.method, obj, action),
                "code_tx": resp.status,
                "method_tx": req.method,
                "ips": req.access_route,
                "query_string_tx": req.query_string,
                "params_map": req.params,
                "headers_map": req.headers,
                "request_time_nr": request_time
            }
            log.info(">>> response %s %s %sms" % (data['routing_key'], json.dumps(req.context.get('result', {})), request_time))
        except Exception as e:
            log.error("faiiled to log request %s", e, exc_info=True)

