@ECHO ON
set errorlevel=
set FILENAME=mercy_%TAG%.zip
set SYMSTORE="C:\\Program Files (x86)\\Windows Kits\\10\\Debuggers\\x64\\symstore.exe"

py -3 build.py

@if errorlevel 1 (
  echo "build.py failed with %errorlevel%"
  exit /b %errorlevel%
)

%SYMSTORE%  add /r /f . /s C:\\symbols /t build

del /S *.pdb

@if errorlevel 1 (
  echo "symstore failed with %errorlevel%"
  exit /b %errorlevel%
)

set MERCY_PYTHON=%CD%\build\python
set PATH=C:\WINDOWS\system32;C:\WINDOWS;C:\WINDOWS\System32\Wbem;C:\WINDOWS\System32\WindowsPowerShell\v1.0\;C:\Program Files (x86)\Graphviz2.38\bin;C:\Program Files\Git\cmd
set PATH=%MERCY_PYTHON%\lib\site-packages\gnome;%MERCY_PYTHON%\bin;%MERCY_PYTHON%;%MERCY_PYTHON%\Scripts;%PATH%
pyinstaller --noconfirm --clean --distpath=dist\mercy bebo_mercy.spec
@if errorlevel 1 (
  echo "stripdown.py failed with %errorlevel%"
  exit /b %errorlevel%
)

xcopy /s /v build\bebodlls\*.dll dist\bebodlls\
@if errorlevel 1 (
  echo "copy failed with %errorlevel%"
  exit /b %errorlevel%
)

xcopy /s /v build\bebodlls\*.exe dist\bebodlls\

@if errorlevel 1 (
  echo "copy failed with %errorlevel%"
  exit /b %errorlevel%
)

call echo %TAG% > dist/version.txt

call "C:\Program Files (x86)\Windows Kits\10\bin\x64\signtool.exe" sign /v /tr http://timestamp.digicert.com /td sha256 /fd sha256 /sha1 4c7a42ee72670cc7e8b2bd4b044221d48fd881a7 .\dist\mercy\bebo_mercy.exe

@if errorlevel 1 (
  echo "signing failed with %errorlevel%"
  exit /b %errorlevel%
)

"C:\Program Files\7-Zip\7z.exe" a -r %FILENAME% -w .\dist\* -mem=AES256
@if errorlevel 1 (
  echo "zip failed with %errorlevel%"
  exit /b %errorlevel%
)

call py -3 -sBc "import hashlib;print(hashlib.sha1(open('%FILENAME%','rb').read()).hexdigest())" > sha1sum.txt
if errorlevel 1 (
  exit /b %errorlevel%
)

"C:\Program Files\Amazon\AWSCLI\aws.exe" s3api put-object --bucket bebo-app --key %ENV%/mercy/latest.zip --body %FILENAME%
@if errorlevel 1 (
  echo "s3 copy failed with %errorlevel%"
  exit /b %errorlevel%
)

"C:\Program Files\Amazon\AWSCLI\aws.exe" s3api put-object --bucket bebo-app --key %ENV%/mercy/version.txt --body dist/version.txt
@if errorlevel 1 (
  echo "s3 copy version.txt failed with %errorlevel%"
  exit /b %errorlevel%
)

"C:\Program Files\Amazon\AWSCLI\aws.exe" s3api put-object --bucket bebo-app --key %ENV%/mercy/sha1sum.txt --body sha1sum.txt
@if errorlevel 1 (
  echo "s3 copy sha1sum.txt failed with %errorlevel%"
  exit /b %errorlevel%
)
