from .encoder import AudioEncoder


class AACEncoder(AudioEncoder):
    def __init__(self, config):
        super().__init__("avenc_aac", config)
        self.options = {
                bitrate: 128000
                }


    def make_elements(self, output_element):
        super().make_elements(output_element);
        return [output_element.make_queue("audio_encoder",
                        max_size_time=3000000000, leaky=1),
                output_element.make(self.element_name, **self.options),
                output_element.make_caps("audio/mpeg"),
                output_element.make_queue("post_audio_enc",
                        max_size_time=1000000000, leaky=0)
                output_element.make("aacparse")]

