from valkyrie.base import Element
from valkyrie.outputs import Output


class Encoder:
    def __init__(self, element_name, config):
        self.element_name = element_name
        self.config = config
        self.is_video = False
        self.is_audio = False
        self.input_format = None
        self.output_format = None
        self.bitrate = 0
        self.options = None

    def make_elements(self, output_element):
        assert isinstance(output_element, Output), "not an output instance"
        return []

class VideoEncoder(Encoder):
    def __init__(self, element_name, config):
        super().__init__(element_name, config)
        self.is_hw_accelerated = False
        self.is_video = True

class AudioEncoder(Encoder):
    def __init__(self, element_name, config):
        super().__init__(element_name, config)
        self.is_audio = True

