from .encoder import VideoEncoder

class NvencEncoder(VideoEncoder):
    def __init__(self, config):
        super().__init__("d3dnvh264enc", config)
        self.options = {
                "rc-mode": "cbrhq",
                "present": "hq",
                "gop-size": config.fps * 2
                }

    def make_elements(self, output_element):
        super().make_elements(output_element);
        return [output_element.make_default_queue("video_encoder"),
                output_element.make(self.element_name, **self.options),
                output_element.make_caps("video/x-h264,width=%d,height=%d,framerate=%d/1" %
                    (self.config.width, self.config.height, self.config.fps))]


