from .encoder import VideoEncoder


# GstX264EncPreset
GST_X264_PRESETS = {
  0: None,
  1: "ultrafast",
  2: "superfast",
  3: "veryfast",
  4: "faster",
  5: "fast",
  6: "medium",
  7: "slow",
  8: "slower",
  9: "veryslow",
  10: "placebo"
}


class X264Encoder(VideoEncoder):
    def __init__(self, config):
        super().__init__("d3dnvh264enc", config)
        self.options = {
                "speed-preset": config.video_encoding_preset,
                "key-int-max": config.fps * 2,
                "pass": "cbr",
                "vbv-buf-capacity": 2000,
                "option-string": "filler=1:scenecut=0"
                }


    def make_elements(self, output_element):
        super().make_elements(output_element);
        return [output_element.make("glcolorconvert"),
                output_element.make_caps('video/x-raw(memory:GLMemory),format=NV12'),
                output_element.make_default_queue("pre_download"),
                output_element.make("gldownload"),
                output_element.make_default_queue("post_download"),
                output_element.make_default_queue("video_encoder"),
                output_element.make(self.element_name, **self.options),
                output_element.make_caps("video/x-h264,width=%d,height=%d,framerate=%d/1" %
                    (self.config.width, self.config.height, self.config.fps))]



