from .mixer import Mixer
from valkyrie.base import AUDIO_MIXER_LATENCY


class AudioMixer(Mixer):
    def __init__(self, config):
        super().__init__("audiomixer", latency=AUDIO_MIXER_LATENCY)
        self.is_audio = True
        self.format = config.audio_format
        self.samplerate = config.samplerate
        self.channels = config.channels

    def create_and_link_elements(self):
        caps = self.make_caps("audio/x-raw,format={},rate=(int){},channels=(int){}".format(
            self.format, self.samplerate, self.channels))
        self.elements = [self.mixer, caps]
        self.elements.append(self.tee)
        self.link_many(*self.elements)
        self.configure_probe_pad()

