from .mixer import Mixer


class VideoMixer(Mixer):
    def __init__(self, session_config):
        super().__init__("glvideomixerelement", background="black")
        self.is_video = True
        self.width = session_config.width
        self.height = session_config.height
        self.fps = session_config.fps

    def create_and_link_elements(self):
        super().create_and_link_elements()
        caps = self.make_caps("video/x-raw(memory:GLMemory),width=%d,height=%d,framerate=%d/1" %
                (self.width, self.height, self.fps))
        queue = self.make_queue("videomixer", max_size_buffers=2, leaky=1)
        self.elements = [self.mixer, caps, queue]
        self.elements.extend(self.make_filter_elements())
        self.elements.append(self.tee)
        self.link_many(*self.elements)
        self.configure_probe_pad()


class VideoMixerGL(VideoMixer):
    def __init__(self):
        super().__init__()


class VideoMixerDXGI(VideoMixer):
    def __init__(self):
        super().__init__()

    def make_filter_elements(self):
        return [self.make("gl2dxgi")]

