from valkyrie.base import Element


class Output(Element):
    def __init__(self, element_name, config, **kwargs):
        super().__init__()
        self.sink = self.make(element_name, **kwargs)
        self.elements = [[], []]
        self.audio_elements = self.elements[0]
        self.video_elements = self.elements[1]
        self.filters = []
        self.audio_encoder = None
        self.video_encoder = None
        self.is_video = False
        self.is_audio = False

    def create_and_link_elements(self):
        super().create_and_link_elements()
        self.audio_elements.extend(self.audio_encoder.make_elements())
        self.video_elements.extend(self.video_encoder.make_elements())

        # FIXME: Link mixer's audio/video to first audio / video sink pad

        self.link_many(*self.audio_elements)
        self.link_many(*self.video_elements)

        # FIXME: Link audio/video pad to the sink respectively
        self.elements.append(self.sink)


    def get_audio_sink_pad(self):
        if len(self.audio_elements) == 0:
            return None
        return self.audio_elements[0].get_static_pad("sink")

    def get_video_sink_pad(self):
        if len(self.video_elements) == 0:
            return None
        return self.video_elements[0].get_static_pad("sink")
