from .source import Source


class AudioSource(Source):
    def __init__(self, name, config, volume, is_mute, is_mono, **kwargs):
        super().__init__(name, config, **kwargs)
        self.config = config
        self.is_audio = True
        self.is_mute = is_mute
        self.is_mono = is_mono
        self.volume = volume

    def get_audio_mixer_pad_props(self):
        return {
                'volume': self.volume,
                'mute': self.is_mute
                }

    def make_src_caps(self):
        return self.make_caps("audio/x-raw,rate=(int){},channels=(int){}".format(self.config.samplerate, self.config.channels))

    def make_filter_elements(self):
        audioconvert = self.make("audioconvert")
        audioresample = self.make("audioresample")
        elements = [audioconvert, audioresample]
        if self.is_mono:
            channelmix = self.make('audiochannelmix', left_to_right=1)
            audioconvert2 = self.make('audioconvert')
            elements.extend([channelmix, audioconvert2])
        return elements

    def make_queue_element(self):
        return self.make_default_audio_queue()

