from valkyrie.base import Element

class Source(Element):
    def __init__(self, element_name, config, **kwargs):
        super().__init__()
        self.src = self.make(element_name, **kwargs)
        self.config = config
        self.filters = []
        self.is_audio = False
        self.is_video = False

    def create_and_link_elements(self):
        super().create_and_link_elements()
        self.elements = [self.src]
        caps = self.make_src_caps()
        if caps:
            self.elements.append(caps)
        self.elements.extend(self.make_filter_elements())
        queue = self.make_queue_element()
        if queue:
            self.elements.append(queue)
        self.link_many(*self.elements)
        self.add_static_ghost_pad()

    def make_src_caps(self):
        return None

    def make_filter_elements(self):
        return []

    def make_queue_element(self):
        return None

    def get_audio_mixer_pad_props(self):
        return None

    def get_video_mixer_pad_props(self):
        return None

    def get_video_src_pad(self):
        return self.get_bin_src_pad()

    def get_audio_src_pad(self):
        return self.get_bin_src_pad()

