from .source import Source

class VideoSource(Source):
    POSITION_ORIGIN = { 'x': 0, 'y': 0 }
    def __init__(self, element_name, config, width, height, position, **kwargs):
        super().__init__(element_name, config, **kwargs)
        self.is_video = True
        self.is_gl = False
        self.width = width
        self.height = height
        self.fps = config.fps
        self.position = position
        self.zorder = 0
        self.alpha = 1.0

    def make_src_caps(self):
        return self.make_caps("video/x-raw,width=%d,height=%d,framerate=%d/1" % (self.width, self.height, self.fps))

    def get_video_mixer_pad_props(self):
        return {
                "xpos": self.position["x"],
                "ypos": self.position["y"],
                "width": self.width,
                "height": self.height,
                "zorder": self.zorder,
                "alpha": self.alpha
                }

    def make_queue_element(self):
         return self.make_queue()

class VideoSourceGL(VideoSource):
    def __init__(self, element_name, config, width, height, position, **kwargs):
        super().__init__(element_name, config, width, height, position, **kwargs)
        self.is_gl = True

    def make_src_caps(self):
        return self.make_caps("video/x-raw(memory:GLMemory),format=RGBA,width=%d,height=%d,framerate=%d/1" % (self.width, self.height, self.fps))
