import logging
from mgst.models import UserModel, NotificationModel, ThreadModel, StreamsModel
from mgst.stream_monitor import stream_monitor, dump_stream_tracker
from mgst.slack_event import handle_slack_event
from mgst.ask_working import send_ask_working_message
from mgst.summary import send_summary
from mgst.alert import send_alert

UserModel.create_table(wait=True)
NotificationModel.create_table(wait=True)
ThreadModel.create_table(wait=True)
StreamsModel.create_table(wait=True)


logging.getLogger().setLevel(logging.INFO)

def stream_monitor_handler(_event, _context):
    return stream_monitor()

def slack_event_handler(event, _context):
    return handle_slack_event(event)

def ask_working(_event, _context):
    return send_ask_working_message()

def dump_tracker_handler(_event, _context):
    return dump_stream_tracker()

def summary(_event, _context):
    return send_summary()

def alert(event, _context):
    return send_alert(event)
