import json
import datetime
from mgst.config import slack_client


def send_alert(event):
    for record in event['Records']:
        msg = json.loads(record['Sns']['Message'])
        print('Sending %s' % msg)
        resp = slack_client.chat_postMessage(
            channel=msg.get('channel', '#mgst-alerts'),
            attachments=[
                {
                    "fallback": msg.get('text'),
                    "color": msg.get('color', "danger"),
                    "title": msg.get('title', 'MGST Alert'),
                    "text":  msg.get('text'),
                    "ts": int(datetime.datetime.utcnow().timestamp())
                }
            ]
        )
        if not resp['ok']:
            raise Exception('Failed to send %s' % resp)
