from .config import slack_client, ASK_CHAN
from .models import ThreadModel
from .utils import get_date
from .sheets import ensure_tab, update_entry

def send_ask_working_message():
    if not ASK_CHAN.strip():
        print("Not asking because ASK_CHAN is empty")
        return

    ask = slack_client.chat_postMessage(
        channel="#%s" % ASK_CHAN,
        text="<!here> :heyguys1000: whatcha working on today? (responses will be recorded)"
    )

    reply = slack_client.chat_postMessage(
        channel=ask['channel'],
        thread_ts=ask['ts'],
        text=":lirikblind: _this does not exist_"
    )

    thread = ThreadModel(ask['channel'], get_date(), slack_ts=ask['ts'])
    thread.save()
    ensure_tab()

def on_threaded_message(event):
    if event.get('subtype') == "bot_message":
        return

    new_ts = event['thread_ts']
    chan = event['channel']

    date = get_date()

    print("checking %s for [%s,%s]" % (ThreadModel.Meta.table_name, chan, date))
    try:

        thread = ThreadModel.get(chan, date)
        saved_ts = thread.slack_ts

        if saved_ts != new_ts:
            print("saved_ts %s != new_ts %s" % (saved_ts, new_ts))
            return

        resp = slack_client.users_info(user=event['user']).data
        user = resp.get('user', {}).get("profile")
        if not user:
            print("no user :/ -- data: %s" % resp)
            return

        real_name = user['real_name']
        slack_name = user['display_name']

        row = '%s \n(@%s)' % (real_name, slack_name)
        update_entry(row, event['text'])

        ts = event['ts']
        slack_client.reactions_add(name='hypereyes', channel=chan, timestamp=ts)
    except ThreadModel.DoesNotExist:
        pass
