import os
from pynamodb.models import Model
from pynamodb.attributes import UnicodeAttribute, UTCDateTimeAttribute, NumberAttribute

# The data in this table is automatically generated, be careful with edits
class UserModel(Model):
    class Meta:
        table_name = "mgst-user-%s" % os.getenv('MGST_ENV', 'local')
        table_name = "mgst-user-%s-2" % os.getenv('MGST_ENV', 'local')
        region = 'us-west-2'
        billing_mode = 'PAY_PER_REQUEST'

    user_id = UnicodeAttribute(hash_key=True)

    user_login = UnicodeAttribute(null=True)
    state = UnicodeAttribute(null=True)


class NotificationModel(Model):
    class Meta:
        table_name = "mgst-notification-%s" % os.getenv('MGST_ENV', 'local')
        table_name = "mgst-notification-%s-2" % os.getenv('MGST_ENV', 'local')
        region = 'us-west-2'
        billing_mode = 'PAY_PER_REQUEST'

    user_id = UnicodeAttribute(hash_key=True) # twitch user_id
    slack_channel = UnicodeAttribute(range_key=True) # #channel

    user_login = UnicodeAttribute(null=True) #twitch username
    slack_ts = UnicodeAttribute(null=True) # automatically generated
    slack_channel_id = UnicodeAttribute(null=True)  # automatically generated

class ThreadModel(Model):
    class Meta:
        table_name = "mgst-threads-%s" % os.getenv('MGST_ENV', 'local')
        region = 'us-west-2'
        billing_mode = 'PAY_PER_REQUEST'

    slack_channel_id = UnicodeAttribute(hash_key=True)
    date = UnicodeAttribute(range_key=True)

    slack_ts = UnicodeAttribute(null=True)

class StreamsModel(Model):
    class Meta:
        table_name = "mgst-streams-%s" % os.getenv("MGST_ENV","local")
        region = 'us-west-2'
        billing_mode = 'PAY_PER_REQUEST'

    stream_id = UnicodeAttribute(hash_key=True)

    user_id = UnicodeAttribute()
    minutes_live = NumberAttribute(default=0)
    ccv = NumberAttribute(default=0)
    hours_watched = NumberAttribute(default=0)

    game_id = UnicodeAttribute(null=True)
    slack_ts = UnicodeAttribute(null=True)
