import calendar
import string

import gspread
from gspread_formatting import *
from oauth2client.service_account import ServiceAccountCredentials

from .utils import get_date, get_sheet_name, get_weekday_offset
from .config import GCP_DICT

SHEET_ID = '18O3XnB3Dx0uqD_L8oMBFP9kOfLdMkT0E0PPX3wDiOVE'
JSON_PATH='MGST Bot-87eef5901aad.json'
ALPHABET = list(string.ascii_uppercase)

HEADERS=["Name"] + list(calendar.day_name)

scope = ['https://spreadsheets.google.com/feeds',
         'https://www.googleapis.com/auth/drive']

credentials = ServiceAccountCredentials._from_parsed_json_keyfile(GCP_DICT, scope)

gc = gspread.authorize(credentials)

wks = gc.open_by_key(SHEET_ID)

def ensure_tab():
    sheet_titles = [sheet.title for sheet in wks.worksheets()]
    sheet_name = get_sheet_name()

    if sheet_name not in sheet_titles:
        print("creating %s" % sheet_name)
        wks.add_worksheet(title=sheet_name, rows="23", cols="6")

    worksheet = wks.worksheet(sheet_name)
    print("ensuring format")
    expected = {"%s1" % ALPHABET[i] : HEADERS[i] for i in range(6)}
    for cell, value in expected.items():
        worksheet.update_acell(cell, value)

    header_fmt=cellFormat(
        textFormat=textFormat(bold=True),
        borders={
            "bottom": {
                "style": "SOLID",
                "width": 3,
                "color": {
                    "red": 0,
                    "green": 0,
                    "blue": 0,
                    "alpha": 1
                }
            }
        },
        horizontalAlignment="CENTER"
    )

    all_fmt=cellFormat(
        wrapStrategy="WRAP",
    )

    widen = {
        "requests": [
            {
                "updateDimensionProperties": {
                    "range": {
                        "sheetId": worksheet._properties['sheetId'],
                        "dimension": "COLUMNS",
                        "startIndex": 0,
                        "endIndex": 7
                    },
                    "properties": {
                        "pixelSize": 240
                    },
                    "fields": "pixelSize"
                }
            }
        ]
    }

    format_cell_ranges(worksheet, [
        ("A1:F1", header_fmt),
        ("A1:F23", all_fmt)
    ])
    worksheet.update_acell("A1", "Name")
    wks.batch_update(widen)

def update_entry(row_label, content):
    sheet = wks.worksheet(get_sheet_name())
    rows = sheet.col_values(1)[1:]

    if row_label in rows:
        index = rows.index(row_label)
    else:
        index = len(rows)

    row = index + 2 # 0 index + the 1 skipped
    col = ALPHABET[get_weekday_offset()+1]
    cell = "%s%s" % (col, row)

    current_content = sheet.acell(cell).value
    if current_content:
        current_content += "\n"

    new_content = current_content + content.strip()
    print("writing \"%s\" to %s" % (new_content, cell))

    sheet.update_acell(cell, new_content)
    sheet.update_acell("A%s" % row, row_label)
