from time import sleep
from mgst.models import *
from mgst.utils import get_user_info_by_login

from pynamodb.models import Model
from pynamodb.attributes import UnicodeAttribute

class OldUserModel(Model):
    class Meta:
        table_name = "mgst-user-%s" % os.getenv('MGST_ENV', 'local')
        region = 'us-west-2'
        read_capacity_units = 1
        write_capacity_units = 1

    user_login = UnicodeAttribute(hash_key=True)
    state = UnicodeAttribute()


class OldNotificationModel(Model):
    class Meta:
        table_name = "mgst-notification-%s" % os.getenv(
            'MGST_ENV', 'local')
        region = 'us-west-2'
        read_capacity_units = 1
        write_capacity_units = 1

    user_login = UnicodeAttribute(hash_key=True) # twitch username
    slack_channel = UnicodeAttribute(range_key=True) # #channel
    slack_ts = UnicodeAttribute(null=True) # automatically generated
    slack_channel_id = UnicodeAttribute(null=True)  # automatically generated


UserModel.create_table(wait=True)
NotificationModel.create_table(wait=True)
ThreadModel.create_table(wait=True)

cache = {}

def get_user(login):
    if login in cache:
        return cache[login]

    cache[login] = get_user_info_by_login(login)
    return cache[login]

for noti in OldNotificationModel.scan():
    try:
        print('getting user %s for noti' %  noti.user_login)
        user_data = get_user(noti.user_login)['data']
        user_id = user_data[0]['id']

        new_noti = NotificationModel(user_id, noti.slack_channel, user_login=noti.user_login, slack_ts=noti.slack_ts, slack_channel_id=noti.slack_channel_id)
        new_noti.save()
    except Exception as e:
        print("Failed to save %s -- %s" % (noti, e))

    print()
    sleep(1)

for user in OldUserModel.scan():
    try:

        print('getting user %s for user' %  noti.user_login)
        user_id = get_user(user.user_login)['data'][0]['id']

        new_user = UserModel(user_id, user_login=user.user_login, state=user.state)
        new_user.save()
    except Exception as e:
        print("Failed to save %s -- %s" % (user, e))
    print()
    sleep(1)
