from datetime import datetime, timedelta
import pytz
import sys

from absl import app, logging

from mgst_data.utils import run
from mgst_data.tahoe_speedup import EXPERIMENT_TABLES


def main(_argv):
    pst_now = pytz.utc.localize(datetime.utcnow()).astimezone(
        pytz.timezone("US/Pacific"))
    pst_last1 = (pst_now - timedelta(days=1)).strftime("%Y-%m-%d")  # yesterday
    pst_last2 = (pst_now - timedelta(days=2)
                 ).strftime("%Y-%m-%d")  # 2 days ago
    pst_drop = (pst_now - timedelta(weeks=24)
                  ).strftime("%Y-%m-%d")  # 6 month ago

    # Load table from tahoe to our redshift
    for table in EXPERIMENT_TABLES:
        logging.info("loading table %s", table)
        run([sys.executable, 'scripts/tahoe_speedup.py',
             '--table_name', table,
             '--start_date', pst_last2, '--end_date', pst_last1,
             '--drop_date', pst_drop])

    run([sys.executable, 'scripts/experiment_analysis.py'])

    logging.info("Done")


if __name__ == '__main__':
    app.run(main)
