from datetime import datetime, timedelta
import pytz
import sys

from absl import app, logging, flags
from absl.flags import FLAGS

from mgst_data.utils import run

flags.DEFINE_boolean('yt_import', True, 'Import yt or not')


def main(_argv):
    pst_now = pytz.utc.localize(datetime.utcnow()).astimezone(
        pytz.timezone("US/Pacific"))
    pst_last0 = (pst_now).strftime("%Y-%m-%d")  # today
    pst_last1 = (pst_now - timedelta(days=1)).strftime("%Y-%m-%d")  # yesterday
    pst_last2 = (pst_now - timedelta(days=2)).strftime("%Y-%m-%d")  # day before yesterday

    if FLAGS.yt_import:
        # Call Youtube API to get country
        run([sys.executable, 'scripts/youtube_country.py', '--start_date',
            pst_last1, '--end_date', pst_last0, '--n_channels', '3000'])

    # Import data from marionette
    run([sys.executable, 'scripts/marionette_import.py', '--start_date',
         pst_last1, '--end_date', pst_last0])

    # Update Metadata
    run([sys.executable, 'scripts/metadata_update.py'])

    # approximate country data
    run([sys.executable, 'scripts/marionette_by_country.py', '--start_date',
         pst_last2, '--end_date', pst_last1])

    logging.info("Done")


if __name__ == '__main__':
    app.run(main)
