from datetime import datetime, timedelta
import pytz
import sys

from absl import app, logging

from mgst_data.utils import run


def main(_argv):
    pst_now = pytz.utc.localize(datetime.utcnow()).astimezone(
        pytz.timezone("US/Pacific"))
    pst_last1 = (pst_now - timedelta(days=1)).strftime("%Y-%m-%d")  # yesterday
    pst_last2 = (pst_now - timedelta(days=2)
                 ).strftime("%Y-%m-%d")  # 2 days ago
    pst_drop = (pst_now - timedelta(weeks=24)
                ).strftime("%Y-%m-%d")  # 6 month ago

    run([sys.executable, 'scripts/tahoe_speedup.py',
         '--table_name', 'play_sessions_qos',
         '--start_date', pst_last2, '--end_date', pst_last1,
         '--drop_date', pst_drop])

    logging.info("Done")


if __name__ == '__main__':
    app.run(main)
