#!/usr/bin/env bash
set -e

IMAGE=424255581144.dkr.ecr.us-west-2.amazonaws.com/mgst-data
TAG=$(whoami)
RUN_NAME=${RUN_NAME:-$(whoami)}
SHA=$(git rev-parse HEAD)

CMD="$1"
shift 1

case $CMD in
build*)
	aws ecr get-login-password --region us-west-2 | docker login --username AWS --password-stdin 424255581144.dkr.ecr.us-west-2.amazonaws.com
	docker build -t ${IMAGE}:${TAG} .
	docker push ${IMAGE}:${TAG}
	echo Image pushed ${IMAGE}:${TAG}
	;;
deploy*)
	aws ecr get-login-password --region us-west-2 | docker login --username AWS --password-stdin 424255581144.dkr.ecr.us-west-2.amazonaws.com
	docker build -t ${IMAGE}:${SHA} .
	docker push ${IMAGE}:${SHA}
	echo Image pushed ${IMAGE}:${SHA}
	DOCKER_IMAGE=${IMAGE}:${SHA} helmfile -f helm/helmfile.yaml apply
	;;
run-local*)
	docker run --rm -it ${IMAGE}:${TAG} "$@"
	;;
run*)
	kubectl -n mgst-data run mgst-data-${RUN_NAME} --rm -i --tty \
		--serviceaccount=mgst-data \
		--restart=Never \
		--image-pull-policy Always \
		--image=${IMAGE}:${TAG} \
		-- "$@"
	;;
log*)
	kubectl -n mgst-data logs mgst-data-${RUN_NAME} -f
	;;
clean*)
	kubectl -n mgst-data delete pod mgst-data-${RUN_NAME}
	;;
*)
	echo "Must specify a command"
	exit 1
	;;
esac
