import boto3
import json

from mgst_data import config

sns = boto3.client('sns', region_name='us-west-2')

def send_alert(alert):
    if config.ENV != 'prod':
        print(f'Alert: {alert}')
        return

    try:
        sns.publish(
            TopicArn=config.ALERT_SNS,
            Message=json.dumps(alert)
        )
    except Exception as e:
        print(f'Alert Failed: {e}')
