import os
import boto3


def ssm(name):
    return boto3.client('ssm', region_name='us-west-2').get_parameter(Name=name)['Parameter']['Value']


ENV = os.getenv('ENV') or 'LOCAL'

DB_HOST = ssm('/mgst-tahoe/tahoe_host')
DB_USER = ssm('/mgst-tahoe/tahoe_user')
DB_PASSWORD = ssm('/mgst-tahoe/tahoe_password')

YOUTUBE_API_KEY = ssm('/mgst-data/youtube_api_key')
ALERT_SNS = 'arn:aws:sns:us-west-2:377472072742:mgst-bot-production-alert'
