chat AS (
  SELECT
    device_id AS subject_id,
    SUM(
      CASE
        WHEN orientation = 'landscape' THEN 1
        ELSE 0
      END
    ) AS landscape_chat_sent,
    SUM(
      CASE
        WHEN t1.date = t2.date
        AND orientation = 'landscape' THEN 1
        ELSE 0
      END
    ) AS d0_landscape_chat_sent,
    SUM(
      CASE
        WHEN t1.date <= t2.date + interval '7 day'
        AND t2.days >= 7
        AND orientation = 'landscape' THEN 1
        ELSE 0
      END
    ) AS d7_landscape_chat_sent,
    SUM(
      CASE
        WHEN t1.date <= t2.date + interval '7 day'
        AND t2.days >= 7
        AND orientation = 'portrait' THEN 1
        ELSE 0
      END
    ) AS d7_portrait_chat_sent
  FROM spade.chat t1
  JOIN metadata m 
    ON  t1.date >= m.start_date 
    AND t1.date <= m.end_date 
  JOIN exp t2 ON t1.device_id = t2.subject_id 
    AND t1.date >= t2.date
  GROUP BY
    1
)