app_session AS (
  SELECT t2.subject_id,
    sum(t1.session_length) / (DATEDIFF(day, MIN(t1.date), MAX(m.end_date)) + 1) as session_length,
    count(*) / (DATEDIFF(day, MIN(t1.date), MAX(m.end_date)) + 1) as session_count
  FROM cubes.app_session_summary t1
    JOIN metadata m ON t1.date >= m.start_date
    AND t1.date <= m.end_date
    JOIN exp t2 ON t1.device_id = t2.subject_id
    AND t1.date >= t2.date
  GROUP BY 1
)