play_session AS (
  SELECT
    t2.subject_id,
    sum(1) as vp_adj,
    sum(
      case
        when t1.date <= t2.date + interval '7 day'
        and t2.days >= 7 then 1
        else 0
      end
    ) as d7_vp_adj,
    sum(
      CASE
        WHEN num_minutes >= 5 then 1
        ELSE 0
      END
    ) AS fmp_adj,
    sum(
      CASE
        WHEN num_minutes >= 5
        and t1.date <= t2.date + interval '7 day'
        and t2.days >= 7 then 1
        ELSE 0
      END
    ) AS d7_fmp_adj,
    sum(num_minutes) as mw_adj,
    sum(
      case
        WHEN t1.date <= t2.date + interval '7 day'
        and t2.days >= 7 then num_minutes
        else 0
      end
    ) as d7_mw_adj,
    SUM(
      CASE WHEN lower(game_on_session_start) in %(target_games)s THEN num_minutes ELSE 0 END
    ) AS mw_mobile_adj,
    sum(
      case
        WHEN t1.date <= t2.date + interval '7 day' and t2.days >= 7
        AND lower(game_on_session_start) in %(target_games)s 
        then num_minutes
        else 0
      end
    ) as d7_mw_mobile_adj
  FROM cubes.play_sessions t1
  JOIN metadata m ON t1.date >= m.start_date
    AND t1.date <= m.end_date
  JOIN exp t2 ON t1.device_id = t2.subject_id
    AND t1.date > t2.date
  GROUP BY
    1
)