app_open AS (
  SELECT
    t2.subject_id,
    SUM(
      CASE
        WHEN t1.date = t2.date THEN 1
        ELSE 0
      END
    ) AS d0_app_open,
    SUM(
      CASE
        WHEN t1.date <= t2.date + interval '7 day' THEN 1
        ELSE 0
      END
    ) AS d7_app_open,
    SUM(1) AS app_open
  FROM spade.branch_app_open t1
  JOIN metadata m 
    ON  t1.date >= m.start_date 
    AND t1.date <= m.end_date 
  JOIN exp t2 ON t1.mweb_device_id = t2.subject_id
    AND t1.date >= t2.date
  GROUP BY
    1
)