play_session AS (
  SELECT
    t2.subject_id,
    sum(
      case
        when (
          player != 'mobile_live_preview'
          or player is null
        ) then 1
        else 0
      end
    ) as non_autoplay_vp,
    sum(
      case
        when (
          player != 'mobile_live_preview'
          or player is null
        )
        and t1.date <= t2.date + interval '7 day'
        and t2.days >= 7 then 1
        else 0
      end
    ) as d7_non_autoplay_vp,
    sum(
      CASE
        WHEN num_minutes >= 5
        and (
          player != 'mobile_live_preview'
          or player is null
        ) then 1
        ELSE 0
      END
    ) AS non_autoplay_fmp,
    sum(
      CASE
        WHEN num_minutes >= 5
        and (
          player != 'mobile_live_preview'
          or player is null
        )
        and t1.date <= t2.date + interval '7 day'
        and t2.days >= 7 then 1
        ELSE 0
      END
    ) AS d7_non_autoplay_fmp,
    sum(
      case
        when (
          player != 'mobile_live_preview'
          or player is null
        ) then num_minutes
        else 0
      end
    ) as non_autoplay_mw,
    sum(
      case
        when (
          player != 'mobile_live_preview'
          or player is null
        )
        and t1.date <= t2.date + interval '7 day'
        and t2.days >= 7 then num_minutes
        else 0
      end
    ) as d7_non_autoplay_mw
  FROM cubes.play_sessions t1
  JOIN metadata m 
    ON  t1.date >= m.start_date 
    AND t1.date <= m.end_date 
  JOIN exp t2 ON t1.device_id = t2.subject_id 
    AND t1.date >= t2.date
  GROUP BY
    1
)