CREATE TABLE IF NOT EXISTS mgst."buffer-refill" (
  date timestamp,
  app_session_id varchar (56),
  app_version varchar (32),
  backend varchar (32),
  backend_version varchar (32),
  bandwidth float,
  broadcaster_software varchar (32),
  broadcast_id bigint,
  browser varchar (256),
  browser_family varchar (32),
  browser_version varchar (32),
  buffering_time float,
  buffer_empty_count bigint,
  buffer_session_id varchar (32),
  channel varchar (25),
  channel_id varchar(255),
  client_app varchar (32),
  client_build_id varchar (255),
  client_time TIMESTAMP,
  cluster varchar (16),
  community_id varchar (36),
  community_name varchar (32),
  content_id varchar (64),
  content_mode varchar (32),
  core_version varchar (32),
  current_bitrate float,
  current_fps bigint,
  customer_id varchar (64),
  device_id varchar (32),
  device_manufacturer varchar (32),
  device_model varchar (52),
  device_software varchar (52),
  distinct_id varchar (32),
  domain varchar (32),
  encrypted boolean,
  flash_version varchar (32),
  game varchar (64),
  hls_target_duration varchar (8),
  ip varchar (15),
  city varchar(255),
  country varchar(255),
  region varchar(255),
  asn varchar(255),
  ad_is_playing boolean,
  is_fallback_player boolean,
  live boolean,
  login varchar (25),
  low_latency boolean,
  manifest_broadcast_id bigint,
  manifest_cluster varchar (5),
  manifest_node varchar (16),
  manifest_node_type varchar (255),
  mobile_connection_type varchar (52),
  multistream_id varchar (255),
  multistream_presentation_id varchar (255),
  multistream_session_id varchar (255),
  node varchar (32),
  os_name varchar (32),
  os_version varchar (32),
  partner boolean,
  platform varchar (32),
  player varchar (32),
  play_session_id varchar (32),
  quality varchar (16),
  serving_id varchar (32),
  squad_stream_id varchar (255),
  squad_stream_presentation_id varchar (255),
  squad_stream_session_id varchar (255),
  stream_format varchar (16),
  stream_status varchar (16),
  time TIMESTAMP,
  time_utc TIMESTAMP,
  ui_version varchar (8),
  url varchar (256),
  user_id varchar(255),
  user_ip varchar (15),
  video_buffer_size float,
  video_load_attempt bigint,
  vid_height bigint,
  vid_width bigint,
  vod_format varchar (16),
  vod_id varchar (32),
  vod_timestamp TIMESTAMP,
  vod_type varchar (16)
) DISTKEY (device_id) SORTKEY ("time");